<?php $__env->startSection('styles'); ?>

<link rel="stylesheet" href="<?php echo e(get_asset('dist/css/c3.min.css')); ?>" />
<link rel="stylesheet" href="<?php echo e(get_asset('dist/css/metrics.css')); ?>" />

<style>
    .content-wrapper>* {
        font-family: 'poppins', 'arial';
    }

    .card-tools-custom {
        float: right;
        margin-right: 0.15rem;
        margin-top: 0.5rem;
    }

    .card-tools-right {
        /* float: right; */
        text-align: right
    }


    .icon-custom {
        right: 2rem !important;
        top: 2rem !important;
    }

    .bg-purple {
        background-color: purple !important;
    }


    .c3-tooltip-container {
        background-color: #ffffff;
        border-radius: 0.25em;
        min-width: 180px !important;
        width: auto !important;
        max-width: 300px;
        min-width: 10%;
        padding: 20px;
        box-shadow: 0 0 1px rgba(0, 0, 0, .125), 0 1px 3px rgba(0, 0, 0, .2);
        pointer-events: auto !important;
    }

    .c3-text {
        transform: translateX(-25px) !important;
        fill: #000 !important;
    }

    .c3 .c3-grid line {
        stroke-opacity: 0.3;
        stroke-width: 1px;
    }

    .c3-xgrid,
    .c3-ygrid {
        stroke-dasharray: 0 0;
    }
</style>
<?php if(checkDemo()): ?>
<link href="<?php echo e(get_asset('dist/css/alertify.core.css')); ?>" rel="stylesheet">
<link href="<?php echo e(get_asset('dist/css/alertify.default.css')); ?>" rel="stylesheet">
<?php endif; ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<script src="<?php echo e(get_asset('dist/js/moment.min.js')); ?>"></script>
<script src="<?php echo e(get_asset('dist/js/d3.v5.min.js')); ?>"></script>
<script src="<?php echo e(get_asset('dist/js/c3.min.js')); ?>"></script>

<div class="content-wrapper" style="">

    <div id="edit-widget-modal-container">

    </div>

    <div id="add-widget-modal-container">

    </div>


    <?php echo $__env->make('dashboard.dashboards.partials._widgets-confirmation-modal',[
    'id' => 'delete-widget',
    'modal_title' =>'Delete Confirmation',
    'method'=> 'DELETE'
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('dashboard.dashboards.partials.success-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('dashboard.dashboards.partials._add-widget-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Content Header (Page header) -->
    <section class="content-header mx-3">
        <div class="container-fluid">
            <div class="row mb-2 mt-3">
                <div class="col-sm-6">
                    <h3> <span style="font-family: 'FontAwesome'"> <?php echo '&'.
                            $dashboard->icon; ?></span>
                        <?php echo e($dashboard->title); ?></h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboards.index')); ?>">Dashboards</a></li>
                        <li class="breadcrumb-item"><?php echo e($dashboard->name); ?></li>
                    </ol>
                </div>
            </div>
        </div>
        <!-- /.container-fluid -->
        <div class="container-fluid home-parent-container">

            <div class="mt-4">
                <button class="btn btn-primary  float-right px-3 py-2 srm-button" type="button" id="add-widget-button"
                    data-url="<?php echo e(route('dashboards.widgets.create',request()->route('dashboard')->id)); ?>">
                    <i class="fas fa-plus"></i> Add Widget
                </button>
            </div>
            <div class="clearfix"></div>
            <div class="home-container" style="min-height:70vh">
                <div class="mt-4">

                    <div class="loader" style="display: none">
                        <img src="<?php echo e(get_asset('dist/images/loader.gif')); ?>" class="loader-img" alt="Loader">
                    </div>

                    <?php if(!$paginatedWidgets->isEmpty()): ?>

                    <div class="row">
                        <?php $__currentLoopData = $paginatedWidgets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $widget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <?php if($widget->resource_id != null): ?>
                        <?php if($widget->resource->getResourceType() == "Charts"): ?>
                        <div
                            class="<?php echo e($widget->resource->isChartFullSize()  ? 'col-md-12 col-12' : 'col-md-6 col-12'); ?>">
                            <div class="card card-primary card-outline" style="min-height: 350px">
                                <?php
                                $chartID = Str::of($widget->resource->name)->kebab();
                                ?>
                                <div class="loader" style="display: none">
                                    <img src="<?php echo e(get_asset('dist/images/loader.gif')); ?>" class="loader-img" alt="Loader">
                                </div>

                                <div class="card-header">
                                    <h3 class="card-title" style="color:black;font-weight:bold">
                                        <?php if($widget->resource->getResourceConfiguration('chart_link')): ?>
                                        <a href="<?php echo e(route('charts.details',$widget->resource->id)); ?>"
                                            style="color:black"><?php echo e($widget->resource->getResourceConfiguration('title')); ?></a>
                                        <?php else: ?>
                                        <?php echo e($widget->resource->getResourceConfiguration('title')); ?>

                                        <?php endif; ?>

                                    </h3>
                                    <div class="card-tools">
                                        <button type="button" class="btn btn-tool delete-widget" data-toggle="modal"
                                            data-target="#delete-widget-modal"
                                            data-url="<?php echo e(route('dashboards.widgets.destroy',[$dashboard->id, $widget->id])); ?>">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <?php
                                    $chartID = Str::of($widget->resource->name)->kebab();
                                    ?>
                                    <div id="<?php echo e($chartID); ?>"></div>
                                    <div id="<?php echo e($chartID); ?>-error" class="error text-danger text-center"></div>

                                    <script>
                                        getChartScript('<?php echo e(route("charts.build",[$widget->resource->id])); ?>','<?php echo e($chartID); ?>')
                                    </script>
                                </div>
                            </div>

                        </div>
                        <?php elseif($widget->resource->getResourceType() == "KPIs / Metrics"): ?>
                        <?php if($widget->resource->configurations->chart_type == "gauge_chart"): ?>
                        <div class="col-md-3 col-12">
                            <?php
                            $chartID = Str::of($widget->resource->name)->kebab();
                            ?>
                            <div class="small-box bg-white">
                                <h6 class="float-left pt-2 pl-2 mb-0" style="font-size:0.8rem"><?php echo e($widget->resource->getResourceConfiguration('title')); ?></h6>
                                <?php if(checkMetricAccessPermission($widget->resource)): ?>

                                <div class="card-tools-right pt-2 float-right">
                                    <button type="button" class="btn btn-tool delete-widget" data-toggle="modal"
                                        data-target="#delete-widget-modal"
                                        data-url="<?php echo e(route('dashboards.widgets.destroy',[$dashboard->id,$widget->id])); ?>">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                                <div class="clearfix"></div>
                                <?php if(!array_key_exists('error',$widget->resource->data)): ?>

                                <div class="inner" style="padding: 0">
                                    <div id="<?php echo e(Str::of($widget->resource->name)->kebab()); ?>"></div>
                                </div>
                                <div id="<?php echo e($chartID); ?>-error" class="error text-danger text-center"></div>

                                <script>
                                    <?php echo $widget->resource->script; ?>

                                </script>
                                <?php else: ?>
                                <div class="text-center text-danger pt-4" style="height: 100px"><?php echo e($widget->resource->data['error']); ?></div>
                                <?php endif; ?>

                                <?php if(!array_key_exists('error',$widget->resource->data)): ?>
                                <?php if($widget->resource->getResourceConfiguration('drill_down')): ?>
                                <a href="<?php echo e(route('metrics.drill',$widget->resource->id)); ?>" class="small-box-footer">
                                    More info <i class="fas fa-arrow-circle-right"></i>
                                </a>
                                <?php endif; ?>
                                <?php else: ?>
                                <div style="height: 30px;background-color:rgba(0, 0, 0, .1)">
                                </div>

                                <?php endif; ?>
                                <?php else: ?>
                                <div class="flex align-middle">
                                    <div id="<?php echo e($chartID); ?>-error" class="error text-danger text-center pt-5 pb-2">
                                        Access denied for this chart
                                    </div>

                                </div>
                                <?php endif; ?>
                            </div>


                        </div>
                        <?php else: ?>

                        <div class="col-md-3 col-12">
                            <div class="small-box <?php echo e($widget->resource->getMetricBgColor()); ?>">
                                <div class="card-tools-custom">
                                    <button type="button" class="btn btn-tool delete-widget" data-toggle="modal"
                                        data-target="#delete-widget-modal"
                                        data-url="<?php echo e(route('dashboards.widgets.destroy',[$dashboard->id, $widget->id])); ?>">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                                <?php if(checkMetricAccessPermission($widget->resource)): ?>
                                <div class="inner">
                                    <?php if(!array_key_exists('error',$widget->resource->data)): ?>

                                    <?php if($widget->resource->getResourceConfiguration('compare_with') != "no_comparison"): ?>
                                    <span data-toggle="custom-tooltip" data-html="true" data-placement="bottom"
                                        title="<?php echo e($widget->resource->data['tooltip']); ?>"
                                        style="margin-left: 1rem;font-size:small">
                                        <?php if(!in_array($widget->resource->getResourceConfiguration('display_format'),['percentage','percentage_of_total'])): ?>
                                        <?php echo e($widget->resource->data['change']); ?>

                                        <?php endif; ?>
                                        (
                                        <?php if(!is_numeric($widget->resource->data['trend'])): ?>
                                        <?php echo e($widget->resource->data['trend']); ?>%
                                        <?php elseif($widget->resource->data['trend_direction'] == "positive"): ?>
                                        ↑<?php echo e($widget->resource->data['trend']); ?>%
                                        <?php elseif($widget->resource->data['trend_direction'] == "negative"): ?>
                                        ↓<?php echo e($widget->resource->data['trend']); ?>%
                                        <?php endif; ?>
                                        )</span><br>
                                    <span <?php if($widget->resource->getResourceConfiguration('compare_with') ==
                                        "no_comparison"): ?>
                                        class="mt-4" <?php endif; ?> data-toggle="custom-tooltip" data-html="true"
                                        data-placement="bottom" style="font-size:2rem;font-weight:bold"
                                        title="<?php echo e($widget->resource->data['tooltip']); ?>"><?php echo e($widget->resource->data['original_metric']); ?></span>
                                    <p><?php echo e($widget->resource->getResourceConfiguration('title')); ?></p>
                                    <?php else: ?>
                                    <h3 <?php if($widget->resource->getResourceConfiguration('compare_with') ==
                                        "no_comparison"): ?>
                                        class="mt-4" <?php endif; ?>><?php echo e($widget->resource->data['original_metric']); ?></h3>
                                    <p><?php echo e($widget->resource->getResourceConfiguration('title')); ?></p>
                                    <?php endif; ?>
                                    <?php else: ?>
                                    <p><?php echo e($widget->resource->getResourceConfiguration('title')); ?></p>
                                    <div class="text-center text-danger" style="height: 75px"><?php echo e($widget->resource->data['error']); ?></div>

                                    <?php endif; ?>

                                </div>
                                <?php if($widget->resource->configurations->chart_type == "info_box_with_icon"): ?>
                                <div class="icon">
                                    <i class="icon-custom fas" style="font-family: 'FontAwesome'"><?php echo $widget->resource->getResourceIcon(); ?></i>
                                </div>
                                <?php endif; ?>

                                <?php if(!array_key_exists('error',$widget->resource->data)): ?>
                                <?php if($widget->resource->getResourceConfiguration('drill_down')): ?>
                                <a href="<?php echo e(route('metrics.drill',$widget->resource->id)); ?>" class="small-box-footer">
                                    More info <i class="fas fa-arrow-circle-right"></i>
                                </a>
                                <?php endif; ?>
                                <?php else: ?>
                                <div style="height: 30px;background-color:rgba(0, 0, 0, .1)">
                                </div>

                                <?php endif; ?>
                                <?php else: ?>
                                <p class="pt-2 pl-2"><?php echo e($widget->resource->getResourceConfiguration('title')); ?></p>
                                <div class="pt-5 text-center pb-2">Access denied for this metric</div>
                                <?php endif; ?>

                            </div>

                        </div>
                        <?php endif; ?>
                        <?php endif; ?>

                        <?php else: ?>
                        <div class="col-md-3 col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title"><?php echo e($widget->title); ?></h3>
                                    <div class="card-tools">
                                        <div class="card-tools">
                                            <div class="dropdown">
                                                <button type="button" id="ellipsisMenu2" data-toggle="dropdown"
                                                    aria-haspopup="true" aria-expanded="false"
                                                    style="border:none;background:none">
                                                    <!-- Your SVG icon -->
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                        fill="currentColor" class="bi bi-three-dots-vertical"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z">
                                                        </path>
                                                    </svg>
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-right"
                                                    aria-labelledby="ellipsisMenu">
                                                    <a class="dropdown-item edit-widget"
                                                        data-url="<?php echo e(route('dashboards.widgets.edit',[$dashboard->id,$widget->id])); ?>">Edit</a>

                                                    <a class="dropdown-item delete-widget" data-toggle="modal"
                                                        data-target="#delete-widget-modal"
                                                        data-url="<?php echo e(route('dashboards.widgets.destroy',[$dashboard->id,$widget->id])); ?>">Delete</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="card-body p-0" style="display: block;">
                                    <ul class="nav nav-pills flex-column">
                                        <?php $__currentLoopData = $widget->report_lists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item">
                                            <a class="nav-link" href="<?php echo e(route('reports.show',$report['id'])); ?>"><?php echo e($report['name']); ?></a>
                                        </li>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>

                            </div>
                        </div>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <?php else: ?>
                    <div class="text-center">
                        <?php echo e(__('dashboards.messages.no_widgets')); ?>

                    </div>
                    <?php endif; ?>

                </div>

            </div>
            <?php if($paginatedWidgets->lastPage() > 1): ?>
            <div class="float-right">
                <?php echo e($paginatedWidgets->appends(request()->query())->links()); ?>

            </div>
            <div class="clearfix"></div>
            <?php endif; ?>

    </section>

</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>

<?php if(checkDemo()): ?>
<script src="<?php echo e(get_asset('dist/js/alertify.min.js')); ?>"></script>
<?php endif; ?>

<script src="<?php echo e(get_asset('dist/js/home.js')); ?>"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/mysqlrep/srmtest.mysqlreports.com/srm/dashboard/resources/views/dashboard/dashboards/show.blade.php ENDPATH**/ ?>