<?php $__env->startSection('styles'); ?>
<!-- DataTables -->
<link rel="stylesheet" href="<?php echo e(get_asset('dist/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel=" stylesheet" href="<?php echo e(get_asset('dist/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
<link rel=" stylesheet" href="<?php echo e(get_asset('dist/plugins/datatables-buttons/css/buttons.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('dashboard.reports.partials.success-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<?php echo $__env->make('dashboard.reports.partials._reports-confirmation-modal',[
'id' => 'delete-report',
'modal_title' =>'Delete Confirmation',
'method'=> 'DELETE'
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div id="change-category-modal-container">

</div>


<div id="display-blank-report-modal-container">
    <?php echo $__env->make('dashboard.reports.blank-reports.show', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>

<div id="edit-report-modal-container">
    <?php echo $__env->make('dashboard.reports.blank-reports.edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php if((isset($blankReportModule) && $blankReportModule->checkWhoCanAccessModule()) || auth()->user()->isAdminOrOwner()): ?>

<div id="create-report-modal-container">
    <?php echo $__env->make('dashboard.reports.blank-reports.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>

<?php endif; ?>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2 mt-2">
                <div class="col-sm-6">
                    <h3> <i class="fa-solid fa-file-text mx-2"></i> Reports</h3>

                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="breadcrumb-item">Reports</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
        <div class="container-fluid mt-5">
            <!-- Use container-fluid for full-width -->

            <div class="form-group mx-2">
                <div class="row">
                    <div class="<?php echo e(auth()->user()->isAdminOrOwner() ? 'col-md-6' : 'col-md-12'); ?>">

                        <form>
                            <div class="form-group">
                                <label for="category-search">Category</label>
                                <select class="form-control" id="category-search">
                                    <?php if(isset($categories)): ?>
                                    <option value="">Choose Category</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->name); ?>"><?php echo e($category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="connection-name-search">Report Name</label>
                                <input type="text" class="form-control" id="report-name-search">
                            </div>

                        </form>
                    </div>
                    <?php if(auth()->user()->isAdminOrOwner()): ?>
                    <div class="col-md-6">
                        <!-- Second column -->
                        <form>
                            <div class="form-group">
                                <label for="creator-search">Creator</label>
                                <select class="form-control" id="creator-search">
                                    <option value="">Choose Creator</option>
                                    <?php $i = 0 ; ?>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(checkDemo()): ?>
                                    <option value="<?php echo e('<user ' .++$i . '>'); ?>"><?php echo e('<user ' .$i . '>'); ?></option>
                                    <?php else: ?>
                                    <option value="<?php echo e($user->user_name); ?>"><?php echo e($user->user_name); ?></option>
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            
                        </form>
                    </div>
                    <?php endif; ?>

                </div>

                <div class="form-group text-center mt-3">
                    <button class="btn btn-primary px-3 py-2 my-2 my-sm-0 srm-button search-filter" type="submit"><i
                            class="fas fa-search"></i> Search</button>
                    <button class="btn btn-outline-primary px-3 py-2 my-2 ml-2 my-sm-0 srm-button reset-filter"
                        type="button"><i class="fa-solid fa-eye"></i> Show All</button>
                </div>
                <div class="card-body mt-2 d-flex justify-content-end">
                    <?php if((isset($blankReportModule) && $blankReportModule->checkWhoCanAccessModule()) ||
                    auth()->user()->isAdminOrOwner()): ?>
                    <button class="btn btn-primary create-report px-3 py-2 float-right srm-button" type="button"
                        data-url="<?php echo e(route('reports.create')); ?>">
                        <i class="fas fa-plus"></i> Add New Report
                    </button>
                    <?php endif; ?>
                </div>


                <div class="card-body">
                    <table id="reports" class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Category</th>
                                <th>Creator</th>
                                <th>Creation Date</th>
                                <th>Access Control</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $i=1;
                            ?>
                            <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><a data-display="inside_page" data-url="<?php echo e(route('reports.show',$report->id)); ?>"
                                        class="text-black display-report" style="cursor:pointer"><?php echo e($report->name); ?></a></td>
                                <td><?php echo e($report->category->name); ?></td>
                                <?php if(checkDemo()): ?>
                                <td><?php echo e(isset($report->creator) ? $report->report_creator : ''); ?></td>
                                <?php else: ?>
                                <td><?php echo e(isset($report->creator) ? $report->creator->user_name : ''); ?></td>

                                <?php endif; ?>
                                <td><?php echo e($report->created_at); ?></td>
                                <td>
                                    <?php echo e($report->access_control_type); ?>

                                    <?php if($report->access_control_type === "Public"): ?>
                                    <span class="tool-question" data-toggle="tooltip" data-placement="top"
                                        title="Access is allowed without authentication.">
                                        <i class="fa-solid fa-circle-question"></i>
                                    </span>

                                    <?php else: ?>
                                    <span class="tool-question" data-toggle="tooltip" data-placement="top"
                                        title="Access is allowed only by
                                        <?php echo e(!is_null($report->getGroupsCanAccessResource()) ? $report->getGroupsCanAccessResource()->implode(' ,') : ''); ?> groups.">
                                        <i class="fa-solid fa-circle-question"></i>
                                    </span>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" id="ellipsisMenu2" data-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false"
                                            style="border:none;background:none">
                                            <!-- Your SVG icon -->
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                fill="currentColor" class="bi bi-three-dots-vertical"
                                                viewBox="0 0 16 16">
                                                <path
                                                    d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                                            </svg>
                                        </button>

                                        <div class="dropdown-menu" aria-labelledby="ellipsisMenu">
                                            <a class="dropdown-item display-report"
                                                data-display="<?php echo e(config('srm_config.dashboard.report_display')); ?>"
                                                data-url="<?php echo e(route('reports.show',$report->id)); ?>">Display</a>
                                            <?php if(
                                            (
                                            isset($report->creator) &&
                                            $report->creator->user_ID == auth()->user()->user_ID
                                            )
                                            ||
                                            auth()->user()->isAdminOrOwner()): ?>
                                            <a class="dropdown-item edit-report"
                                                data-url="<?php echo e(route('reports.edit',$report->id)); ?>"
                                                data-display="<?php echo e(route('reports.show',$report->id)); ?>">Edit</a>

                                            <a class="dropdown-item change-category"
                                                data-url="<?php echo e(route('reports.getCategories',$report->id)); ?>">Change
                                                category</a>

                                            <a class="dropdown-item delete-report" data-toggle="modal"
                                                data-target="#delete-report-modal"
                                                data-url="<?php echo e(route('reports.destroy',$report->id)); ?>">Delete</a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
            </div>

        </div>

</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script src="<?php echo e(get_asset('dist/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/dataTables.buttons.min.js')); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/buttons.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/jszip/jszip.min.js')); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/pdfmake/pdfmake.min.js')); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/pdfmake/vfs_fonts.js')); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/buttons.html5.min.js')); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/buttons.print.min.js')); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/buttons.colVis.min.js')); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(get_asset('dist/js/custom-datatables.js')); ?>"></script>

<script>
    displayUserPanel();
</script>

<script src="<?php echo e(get_asset('dist/js/reports.js')); ?>">
</script>

<?php if(session('add')): ?>
<script>
    $(document).ready(function() {
            $('.create-report').click();
        });
</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/mysqlrep/srmtest.mysqlreports.com/srm/dashboard/resources/views/dashboard/reports/index.blade.php ENDPATH**/ ?>