<div class="form-group mt-4">
    <div class="row">
        <div class="col-md-6">

            <form>
                <div class="form-group">
                    <label for="userName-search">User Name</label>
                    <input type="text" class="form-control" id="userName-search">
                </div>
                <div class="form-group">
                    <label for="fullname-search">Name</label>
                    <input type="text" class="form-control" id="fullname-search">
                </div>
                <div class="form-group">
                    <label for="email-search">Email</label>
                    <input type="text" class="form-control" id="email-search">
                </div>
            </form>
        </div>
        <div class="col-md-6">

            <form>
                <div class="form-group">
                    <label for="group-search">Group</label>
                    <select class="form-control" id="group-search">
                        <option value="">All</option>
                        <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($group->name); ?>"><?php echo e($group->name); ?></option>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="status-search">Status</label>
                    <select class="form-control" id="status-search">
                        <option value="">All</option>
                        <option value="active">Active</option>
                        <option value="pended">Pended</option>
                        <option value="blocked">Blocked</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="emailConfirmation-search">Email Confirmation</label>
                    <select class="form-control" id="emailConfirmation-search">
                        <option value="">All</option>
                        <option value="yes">Confirmed</option>
                        <option value="no">Not Confirmed</option>
                    </select>
                </div>
            </form>
        </div>
    </div>

    <div class="form-group text-center">
        <button class="btn btn-primary px-3 py-2 my-2 my-sm-0 srm-button search-filter" type="submit"><i
                class="fas fa-search"></i> Search</button>
        <button class="btn btn-outline-primary px-3 py-2 my-2 ml-2 my-sm-0 srm-button reset-filter" type="button"><i
                class="fa-solid fa-eye"></i> Show
            All</button>
    </div>
    </form>

    <div class="mt-2 d-flex justify-content-end">
        <button class="btn btn-primary add-user-button px-3 py-2 float-right srm-button" type="button"
            data-toggle="modal" data-target="#add-user-modal">
            <i class="fas fa-plus"></i> Add New User
        </button>
    </div>

</div>
<div class="clearfix card-body mt-3 table-responsive" width="100%">
    <table id="users" class="table table-bordered table-hover">
        <thead>
            <tr>
                <th>User Name</th>
                <th>Name</th>
                <th>Email</th>
                <th>Group</th>
                <th>Status</th>
                <th>Email Confirmed</th>
                <th>Actions</th>

            </tr>
        </thead>
        <tbody>
            <?php $i=0; ?>
            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <?php if(checkDemo()): ?>
                <td><?php echo e("<User ". ++$i . ">"); ?></td>
                <td><?php echo e("<Name>"); ?></td>
                <td><?php echo e("<Email>"); ?></td>
                <?php else: ?>
                <td><?php echo e($user->user_name); ?></td>
                <td><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></td>
                <td><?php echo e($user->Email); ?></td>

                <?php endif; ?>
                <td><?php echo e(isset($user->group->name) ? $user->group->name : ''); ?></td>
                <td>
                    <?php switch($user->status):
                    case ("Active"): ?>
                    <span class="badge bg-success"><?php echo e($user->status); ?></span>
                    <?php break; ?>
                    <?php case ("Pended"): ?>
                    <span class="badge bg-warning"><?php echo e($user->status); ?></span>
                    <?php break; ?>

                    <?php case ("Blocked"): ?>
                    <span class="badge bg-danger"><?php echo e($user->status); ?></span>
                    <?php break; ?>
                    <?php endswitch; ?>
                </td>
                <td>
                    <?php if($user->isEmailConfirmed()): ?>
                    <span class="badge bg-success">Yes</span>
                    <?php else: ?>
                    <span class="badge bg-warning">No</span>

                    <?php endif; ?>
                </td>
                <td>
                    <?php if(!$user->isAdminAndOwner()): ?>

                    <div class="dropdown">
                        <button type="button" id="ellipsisMenu" data-toggle="dropdown" aria-haspopup="true"
                            aria-expanded="false" style="border:none;background:none">

                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                class="bi bi-three-dots-vertical" viewBox="0 0 16 16">
                                <path
                                    d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                            </svg>
                        </button>
                        <div class="dropdown-menu" aria-labelledby="ellipsisMenu">

                            <a class="dropdown-item edit-user"
                                data-url="<?php echo e(route('users.edit',$user->user_ID)); ?>">Edit</a>
                            <?php if(strtolower($user->status) == "pended"): ?>
                            <?php if(!$user->isAdminOrOwner()): ?>
                            <a class="dropdown-item activate-user" data-toggle="modal"
                                data-target="#activate-user-modal"
                                data-url="<?php echo e(route('users.activate',$user->user_ID)); ?>">Activate</a>
                            <?php else: ?>
                            <form method="POST" id="activate-admin-user-form"
                                data-url="<?php echo e(route('users.activate-admin',$user->user_ID)); ?>">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PATCH'); ?>
                            </form>
                            <a class="dropdown-item activate-admin-user">Activate</a>

                            <?php endif; ?>
                            <?php endif; ?>
                            <?php if(strtolower($user->status) == "blocked"): ?>

                            <a class="dropdown-item unblock-user" data-toggle="modal" data-target="#unblock-user-modal"
                                data-url="<?php echo e(route('users.unblock',$user->user_ID)); ?>">unblock</a>
                            <?php else: ?>
                            <a class="dropdown-item block-user" data-toggle="modal" data-target="#block-user-modal"
                                data-url="<?php echo e(route('users.block',$user->user_ID)); ?>">Block</a>
                            <?php endif; ?>
                            <a class="dropdown-item delete-user" data-toggle="modal" data-target="#delete-user-modal"
                                data-url="<?php echo e(route('users.destroy',$user->user_ID)); ?>">Delete</a>
                        </div>
                    </div>


                </td>
                <?php endif; ?>

            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php /**PATH /home1/mysqlrep/srmtest.mysqlreports.com/srm/dashboard/resources/views/dashboard/users/partials/_users.blade.php ENDPATH**/ ?>