<div class="modal fade" id="{{ $id }}-modal" tabindex="-1" role="dialog" aria-labelledby="{{ $id }}-modal"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content custom-rounded-edges">
            <div class="modal-header">
                <h5 class="modal-title ml-3" id="exampleModalLongTitle">
                    <i class="fa-solid fa-users mx-2"></i>
                    Group Details
                </h5>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body mx-4 my-3">
                <form data-url="{{ route('groups.store') }}" id="{{ $id }}-form">
                    @csrf
                    <div class="form-group">

                        <label for="name" class="mr-2 h5">Group Name</label>
                        <input type="text" class="form-control" id="group-name" name="name"
                            placeholder="Enter group name">

                    </div>
                    @if($modules->count())
                    <h5>Permissions</h5>
                    <div class="accordion my-3" id="mainaccordion">
                        @foreach ($modules as $module)
                        <div class="card">
                            <div class="card-header" id="{{ str_replace(' / ','-',$module->name) }}-heading"
                                data-toggle="collapse"
                                data-target="#{{ str_replace(' / ','-',$module->name) }}-collapse" aria-expanded="true"
                                aria-controls="{{ str_replace(' / ','-',$module->name) }}-collapse">
                                <h5 class="mb-0">
                                    <!-- <input type="checkbox" id="checkboxOne">  -->
                                    <label for="checkboxOne" class="mt-1"> {!! $module->logo !!} {{ $module->name
                                        }}</label>
                                </h5>
                            </div>

                            <div id="{{ str_replace(' / ','-',$module->name) }}-collapse" class="collapse show"
                                aria-labelledby="headingOne">
                                <div class="card-body row" style="
                                max-height: 150px;
                                overflow-y: scroll;
                                overflow-x: hidden;
                                width: 100%;
                            ">
                                    <div class="col-12">
                                        <div>
                                            <input type="checkbox" id="can-create-{{ $module->name }}"
                                                name="permissions[create][]" value="{{ $module->id }}">
                                            <span for="can-create-{{ $module->name }}" class="mx-1">Can Create New {{
                                                $module->name }}</span>
                                            <span class="tool-question mx-2" data-toggle="tooltip" data-placement="top"
                                                title=""
                                                data-original-title="Selecting this checkbox grants users within this group permission to create new {{ $module->name }}. The user creating the new {{ $module->name }} will also have the ability to edit and delete them.">
                                                <i class="fa-solid fa-circle-question"></i>
                                            </span>

                                        </div>
                                    </div>
                                    @if($module->resources->count() || $module->children->count())

                                    <div class="col-12">
                                        <label for="" class="mb-1 mt-2"> <i class="fa-solid fa-eye fa-fw"></i> Access
                                            Existing {{
                                            $module->name }}</label>
                                        <span class="tool-question mx-2" data-toggle="tooltip" data-placement="top"
                                            title=""
                                            data-original-title="Check the checkboxes next to the {{ $module->name }} to grant access to users in this group.">
                                            <i class="fa-solid fa-circle-question"></i>
                                        </span>

                                    </div>
                                    <!-- Three children with checkboxes -->
                                    @foreach($module->resources as $resource)
                                    <div class="col-4 mt-2">
                                        <div>
                                            <input type="checkbox" id="can-access-{{ $resource->name }}"
                                                name="permissions[access][]" value="{{ $resource->id }}">
                                            <span for="can-access-{{ $resource->name }}" class="mx-1">{{ $resource->name
                                                }}</span>
                                        </div>
                                    </div>
                                    @endforeach

                                    @foreach($module->children as $child)
                                    @foreach($child->resources as $resource)
                                    <div class="col-4 mt-2">
                                        <div>
                                            <input type="checkbox" id="can-access-{{ $resource->name }}"
                                                name="permissions[access][]" value="{{ $resource->id }}">
                                            <span for="can-access-{{ $resource->name }}" class="mx-1">{{ $resource->name
                                                }}</span>
                                        </div>
                                    </div>
                                    @endforeach
                                    @endforeach
                                    @endif
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @endif

                    <div class="text-center">
                        <button type="button" id="saveBtn-{{ $id }}" class="btn btn-primary mx-2 px-5 py-2 my-2">
                            Save
                        </button>
                        <button type="button" class="btn btn-light mx-2 px-5 py-2 my-2" id="cancelBtn-{{ $id }}"
                            data-dismiss="modal">
                            Cancel
                        </button>

                    </div>
                    <div class="col-md-12 mt-3">
                        <div id="{{ $id }}-confirm" class="alert bootstrap-alert-success mx-4 mb-3" role="alert"
                            style="display: none">
                        </div>
                        <div id="{{ $id }}-error" class="alert bootstrap-alert-danger mx-4 mb-3" role="alert"
                            style="display: none">
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
