@extends('layouts.app')

@section('styles')

<link rel="stylesheet" href="{{ get_asset('dist/css/c3.min.css') }}" />
<link rel="stylesheet" href="{{ get_asset('dist/css/metrics.css') }}" />
<link rel="stylesheet" href="{{ get_asset('dist/css/c3.custom.css') }}" />
<style>
    .card-tools-custom {
        float: right;
        margin-right: 0.15rem;
        margin-top: 0.5rem;
    }

    .card-tools-right {
        /* float: right; */
        text-align: right
    }


    .icon-custom {
        right: 2rem !important;
        top: 2rem !important;
    }

    .bg-purple {
        background-color: purple !important;
    }
</style>
@if(checkDemo())
<link href="{{ get_asset('dist/css/alertify.core.css')}}" rel="stylesheet">
<link href="{{ get_asset('dist/css/alertify.default.css')}}" rel="stylesheet">
@endif
@endsection


@section('content')
<script src="{{ get_asset('dist/js/moment.min.js')}}"></script>
<script src="{{ get_asset('dist/js/d3.v5.min.js')}}"></script>
<script src="{{ get_asset('dist/js/c3.min.js')}}"></script>

<div class="content-wrapper" style="">

    <div id="edit-widget-modal-container">

    </div>

    <div id="add-widget-modal-container">

    </div>


    @include('dashboard.home.partials._widgets-confirmation-modal',[
    'id' => 'delete-widget',
    'modal_title' =>'Delete Confirmation',
    'method'=> 'DELETE'
    ])

    @include('dashboard.home.partials.success-modal')

    @include('dashboard.home.partials._add-widget-modal')

    <!-- Content Header (Page header) -->
    <section class="content-header mx-3">
        <div class="container-fluid">
            <div class="row mt-3">
                <div class="col-sm-6">
                    <h3> <i class="fas fa-home fa-fw"></i>
                        Home</h3>
                </div>
                <div class="col-sm-6">
                    <button type="button" id="add-widget-button"
                        class="btn btn-primary float-right px-3 py-2 srm-button"
                        data-url="{{ route('home.widgets.create') }}">
                        <i class="fas fa-plus"></i> Add Widget
                    </button>
                </div>
            </div>
        </div>
        <!-- /.container-fluid -->
        <div class="container-fluid home-parent-container">
            <div class="home-container" style="min-height:70vh">
                <div class="mt-4">
                    <div class="loader" style="display: none">
                        <img src="{{get_asset('dist/images/loader.gif')}}" class="loader-img" alt="Loader">
                    </div>
                    @if(!$homeDashboardItems->isEmpty())

                    <div class="row">
                        @foreach ($homeDashboardItems as $item)
                        @if($item->resource_id != null)
                        @if($item->resource->getResourceType() == "Charts")
                        <div class="{{ $item->resource->isChartFullSize()  ? 'col-md-12 col-12' : 'col-md-6 col-12'}}">
                            <div class="card card-primary card-outline" style="min-height: 350px">
                                @php
                                $chartID = Str::of($item->resource->name)->kebab();
                                @endphp
                                <div class="loader" style="display: none">
                                    <img src="{{get_asset('dist/images/loader.gif')}}" class="loader-img" alt="Loader">
                                </div>

                                <div class="card-header">
                                    <h3 class="card-title" style="color:black;font-weight:bold">
                                        @if($item->resource->getResourceConfiguration('chart_link'))
                                        <a href="{{ route('charts.details',$item->resource->id) }}"
                                            style="color:black">{{
                                            $item->resource->getResourceConfiguration('title') }}</a>
                                        @else
                                        {{ $item->resource->getResourceConfiguration('title') }}
                                        @endif

                                    </h3>
                                    <div class="card-tools">
                                        <button type="button" class="btn btn-tool delete-widget" data-toggle="modal"
                                            data-target="#delete-widget-modal"
                                            data-url="{{ route('home.widgets.destroy',[$item->id]) }}">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    @php
                                    $chartID = Str::of($item->resource->name)->kebab();
                                    @endphp
                                    <div id="{{ $chartID }}"></div>
                                    <div id="{{ $chartID }}-error" class="error text-danger text-center"></div>

                                    <script>
                                        getChartScript('{{ route("charts.build",[$item->resource->id]) }}','{{ $chartID }}')
                                    </script>
                                </div>
                            </div>

                        </div>
                        @elseif($item->resource->getResourceType() == "KPIs / Metrics")
                        @if($item->resource->configurations->chart_type == "gauge_chart")
                        <div class="col-md-3 col-12">

                            <div class="small-box bg-white">
                                <h6 class="float-left pt-2 pl-2 mb-0" style="font-size:0.8rem">{{
                                    $item->resource->getResourceConfiguration('title')
                                    }}</h6>
                                @if(checkMetricAccessPermission($item->resource))
                                <div class="card-tools-right pt-2 float-right">
                                    <button type="button" class="btn btn-tool delete-widget" data-toggle="modal"
                                        data-target="#delete-widget-modal"
                                        data-url="{{ route('home.widgets.destroy',[$item->id]) }}">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                                <div class="clearfix"></div>
                                @if(!array_key_exists('error',$item->resource->data))

                                <div class="inner" style="padding: 0">
                                    <div id="{{ Str::of($item->resource->name)->kebab() }}"></div>
                                </div>
                                <script>
                                    {!! $item->resource->script !!}
                                </script>
                                @else
                                <div class="text-center text-danger pt-4" style="height: 100px">{{
                                    $item->resource->data['error'] }}</div>
                                @endif
                                @if(!array_key_exists('error',$item->resource->data))

                                @if($item->resource->getResourceConfiguration('drill_down'))
                                <a href="{{ route('metrics.drill',$item->resource->id) }}" class="small-box-footer">
                                    More info <i class="fas fa-arrow-circle-right"></i>
                                </a>
                                @endif
                                @else
                                <div style="height: 30px;background-color:rgba(0, 0, 0, .1)">
                                </div>

                                @endif
                                @else
                                <div class="flex align-middle">
                                    <div id="{{ $chartID }}-error" class="error text-danger text-center pt-5 pb-2">
                                        Access denied for this chart
                                    </div>

                                </div>
                                @endif
                            </div>


                        </div>
                        @else

                        <div class="col-md-3 col-12">
                            <div class="small-box {{ $item->resource->getMetricBgColor() }}">
                                <div class="card-tools-custom">
                                    <button type="button" class="btn btn-tool delete-widget" data-toggle="modal"
                                        data-target="#delete-widget-modal"
                                        data-url="{{ route('home.widgets.destroy',[$item->id]) }}">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                                @if(checkMetricAccessPermission($item->resource))
                                <div class="inner">
                                    @if(!array_key_exists('error',$item->resource->data))
                                    @if($item->resource->getResourceConfiguration('compare_with') != "no_comparison")
                                    <span data-toggle="custom-tooltip" data-html="true" data-placement="bottom"
                                        title="{{ $item->resource->data['tooltip'] }}"
                                        style="margin-left: 1rem;font-size:small">
                                        @if(!in_array($item->resource->getResourceConfiguration('display_format'),['percentage','percentage_of_total']))
                                        {{ $item->resource->data['change'] }}
                                        @endif
                                        (
                                        @if(!is_numeric($item->resource->data['trend']))
                                        {{$item->resource->data['trend'] }}%
                                        @elseif($item->resource->data['trend_direction'] == "positive")
                                        ↑{{$item->resource->data['trend'] }}%
                                        @elseif($item->resource->data['trend_direction'] == "negative")
                                        ↓{{$item->resource->data['trend'] }}%
                                        @endif
                                        )</span><br>
                                    <span @if($item->resource->getResourceConfiguration('compare_with') ==
                                        "no_comparison")
                                        class="mt-4" @endif data-toggle="custom-tooltip" data-html="true"
                                        data-placement="bottom" style="font-size:2rem;font-weight:bold"
                                        title="{{ $item->resource->data['tooltip'] }}">{{
                                        $item->resource->data['original_metric'] }}</span>
                                    <p>{{ $item->resource->getResourceConfiguration('title') }}</p>
                                    @else

                                    <h3 @if($item->resource->getResourceConfiguration('compare_with') ==
                                        "no_comparison")
                                        class="mt-4" @endif>{{ $item->resource->data['original_metric'] }}</h3>
                                    <p>{{ $item->resource->getResourceConfiguration('title') }}</p>
                                    @endif
                                    @else
                                    <p>{{ $item->resource->getResourceConfiguration('title') }}</p>
                                    <div class="text-center text-danger" style="height: 75px">{{
                                        $item->resource->data['error'] }}</div>

                                    @endif

                                </div>
                                @if($item->resource->configurations->chart_type == "info_box_with_icon")
                                <div class="icon">
                                    <i class="icon-custom fas" style="font-family: 'FontAwesome'">{!!
                                        $item->resource->getResourceIcon() !!}</i>
                                </div>
                                @endif
                                @if(!array_key_exists('error',$item->resource->data))

                                @if($item->resource->getResourceConfiguration('drill_down'))
                                <a href="{{ route('metrics.drill',$item->resource->id) }}" class="small-box-footer">
                                    More info <i class="fas fa-arrow-circle-right"></i>
                                </a>
                                @endif
                                @else
                                <div style="height: 30px;background-color:rgba(0, 0, 0, .1)">
                                </div>

                                @endif
                                @else
                                <p class="pt-2 pl-2">{{ $item->resource->getResourceConfiguration('title') }}</p>
                                <div class="pt-5 text-center pb-2">Access denied for this metric</div>
                                @endif

                            </div>

                        </div>
                        @endif
                        @endif

                        @else
                        <div class="col-md-3 col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">{{ $item->widget_title }}</h3>
                                    <div class="card-tools">
                                        <div class="card-tools">
                                            <div class="dropdown">
                                                <button type="button" id="ellipsisMenu2" data-toggle="dropdown"
                                                    aria-haspopup="true" aria-expanded="false"
                                                    style="border:none;background:none">
                                                    <!-- Your SVG icon -->
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                        fill="currentColor" class="bi bi-three-dots-vertical"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z">
                                                        </path>
                                                    </svg>
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-right"
                                                    aria-labelledby="ellipsisMenu">
                                                    <a class="dropdown-item edit-widget"
                                                        data-url="{{ route('home.widgets.edit',$item->id) }}">Edit</a>

                                                    <a class="dropdown-item delete-widget" data-toggle="modal"
                                                        data-target="#delete-widget-modal"
                                                        data-url="{{ route('home.widgets.destroy',$item->id) }}">Delete</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="card-body p-0" style="display: block;">
                                    <ul class="nav nav-pills flex-column">
                                        @foreach ($item->report_lists as $report)
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('reports.show',$report['id']) }}">{{
                                                $report["name"] }}</a>
                                        </li>

                                        @endforeach
                                    </ul>
                                </div>

                            </div>
                        </div>
                        @endif
                        @endforeach

                    </div>
                    @else
                    <div class="text-center">
                        {{ __('home.messages.no_widgets') }}
                    </div>
                    @endif

                </div>

            </div>
            @if($homeDashboardItems->lastPage() > 1)
            <div class="float-right">
                {{ $homeDashboardItems->appends(request()->query())->links() }}
            </div>
            <div class="clearfix"></div>
            @endif

    </section>

</div>
@endsection


@section('scripts')
@if(checkDemo())
<script src="{{ get_asset('dist/js/alertify.min.js')}}"></script>
@endif
<script src="{{ get_asset('dist/js/home.js')}}"></script>




@endsection
