<?php

namespace App\Services;

use App\Models\Setting;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;

class BrandingService
{


    public function update($branding)
    {
        if ($branding) {
            $imageName = Str::uuid() . '.' .  $branding->getClientOriginalExtension();
            $path = $branding->storeAs('logos', $imageName, 'public');
            saveSetting('system_logo', $path);
        }
    }

    public function destroy()
    {
        Storage::disk('public')->delete(getSettingsValue('system_logo'));

        saveSetting('system_logo', Setting::DEFAULT_BRANDING_LOGO);
    }
}
