<?php

namespace App\Rules;

use Closure;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Contracts\Validation\ValidationRule;

class CheckDeletedAccount implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $user = User::where('Email', $value)->withTrashed()->first();
        if ($user && $user->trashed() && $this->checkAccountValid($value)) {
            $fail(trans('auth.accout_deleted'));
        }
    }

    public function checkAccountValid($value)
    {
        $user = User::where('Email', $value)->withTrashed()->first();
        if (Hash::check(request()->password, $user->Password)) {
            return true;
        }
        return false;
    }
}