<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory;
    protected $primaryKey = 'ID';
    protected $connection = 'mysql';
    const DEFAULT_BRANDING_LOGO = 'dist/images/srm-logo.jpg';

    protected $fillable = [
        'settings_key',
        'settings_value',
    ];

    public $timestamps = false;

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}Settings";
    }
}
