<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ScheduledTaskSendingLog extends Model
{
    use HasFactory;

    protected $primaryKey = 'id';
    protected $connection = 'mysql';
    public $timestamps = false;


    protected $fillable = [
        'created_at',
        'ended_at',
        'scheduled_tasks_count',
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}scheduled_tasks_sending_log";
    }


}
