<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\Pivot;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ScheduledTaskGroup extends Pivot
{
    use HasFactory;

    protected $connection = 'mysql';
    public $timestamps = false;


    protected $fillable = [
        'task_id',
        'group_id',
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}scheduled_task_groups";
    }

    public function users()
    {
        return $this->hasMany(User::class, 'group_ID', 'group_id');
    }
}
