<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ResourcePermission extends Model
{
    use HasFactory;

    protected $connection = 'mysql';


    protected $fillable = [
        'group_id',
        'resource_id',
        'can_view',
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}resource_permissions";
    }

    public function resource()
    {
        return $this->belongsTo(Resource::class, 'resource_id');
    }

    public function groups()
    {
        return $this->belongsTo(Group::class, 'group_id');
    }
}
