<?php

namespace App\Models;

use Illuminate\Support\Facades\File;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Organization extends Model
{
    use HasFactory;

    protected $primaryKey = 'id';
    protected $connection = 'mysql';

    protected $fillable = [
        'name',
        'logo',
        'contact_info',
        'tax_info'
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}organization";
    }


    public function getLogo()
    {
        $organization = Organization::first();
        if ($organization) {
            return File::exists(public_path("srm_storage/$organization->logo"))
                ? get_asset("srm_storage/$organization->logo")
                : $this->getDefaultLogoPlaceholder();
        }
    }


    public function getDefaultLogoPlaceholder()
    {
        return get_asset("dist/images/2.png");
    }
}