<?php

namespace App\Models;

use App\Models\Resource;
use Illuminate\Support\Facades\File;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class Dashboard extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $primaryKey = 'id';
    protected $connection = 'mysql';

    protected $fillable = [
        'name',
        'icon',
        'title',
        'user_id',
        'url',
        'order',
    ];


    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}dashboards";
    }

    public function resource()
    {
        return $this->hasOne(Resource::class, 'resource_id');
    }

    public function widgets()
    {
        return $this->hasMany(DashboardWidget::class, 'dashboard_id');
    }

}
