<?php

namespace App\Mails;

use App\Mails\SendMail;
use App\Mails\MailTrait;
use App\Mails\MailInterface;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Config;
use App\Exceptions\SystemErrorException;
use App\Models\Resource;
use Illuminate\Validation\ValidationException;

class ReportTestMail implements MailInterface
{
    use MailTrait;

    public $user;
    public $report;
    private $subject;
    private $content;
    private $username;
    private $signature;
    private $headers;
    private $receiver;

    public function __construct($report,$user)
    {
        $this->user = $user;
        $this->report = $report;
    }

    public function setReceivcer($receiver)
    {
        $this->receiver = $receiver;
        return $this;
    }

    public function setHeaders()
    {
        $this->headers = 'From: ' . get_from_name() . ' <' . $this->receiver . '>';
        return $this;
    }

    public function buildMailMessage($subject)
    {
        $this->setSubject($subject)
            ->setUsername(get_user_name($this->user))
            ->setSignature(get_email_signature($this->user))
            ->setReceivcer($this->receiver)
            ->setHeaders()
            ->setMessageContent();
    }

    public function send()
    {
        $this->buildMailMessage("Report Test");

        SendMail::mail(
            $this->receiver,
            $this->subject,
            $this->content,
            $this->headers,
            $this->report
        );
    }

    public function setMessageContent()
    {

        $this->content = view(
            'dashboard.mails.test'
        )->render();
    }
}
