<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class testDataConnectionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $prefix = config("srm_config.installer.table_prefix", "srm_");
        return [
            "database_type" => ["required"],
            "server" => ["required"],
            "database" => ["required"],
            "username" => ["required"],
            "password" => ["required"],
            "port" => ["nullable", "numeric"],
            "charset" => ["nullable"],
            "collation" => ["nullable"],
        ];
    }

    public function messages()
    {
        return [
            "*.required" => ":attribute can't be empty.",
        ];
    }
}
