<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class storeGroupRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $prefix = config("srm_config.installer.table_prefix", "srm_");

        return [
            'name' => ["required", "min:4", "max:50", "unique:{$prefix}Group"]
        ];
    }

    public function messages()
    {
        return [
            "name.required" => "The group name can't be empty.",
            "name.min" => "The group name must be between 4 and 50 characters.",
            "name.max" => "The group name must be between 4 and 50 characters.",
            "name.unique" => "This group name is already existed in the database, please try a different name for the group.",
        ];
    }
}
