<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateDashboardRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $prefix = config("srm_config.installer.table_prefix", "srm_");

        return [
            'dashboard_name' => ['required', 'string', 'max:15', Rule::unique($prefix.'dashboards', 'name')
            ->using(function ($q) {
                $q->where('user_id', auth()->user()->user_ID)
                ->where('id', '!=', request()->route('dashboard')->id);
            })],
            'dashboard_title' => ['required', 'string','max:50'],
            'dashboard_icon' => ['nullable'],
        ];
    }

    public function messages()
    {
        return [
            'dashboard_name.required' => trans('dashboards.validations.required.dashboard_name'),
            'dashboard_title.required' => trans('dashboards.validations.required.dashboard_title'),
            'dashboard_name.max' => trans('dashboards.validations.max.dashboard_name'),
            'dashboard_title.max' => trans('dashboards.validations.max.dashboard_title')
            // 'dashboard_icon.required' => trans('dashboards.validations.required.dashboard_icon'),
        ];
    }
}
