<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules\Password;
use Illuminate\Foundation\Http\FormRequest;

class UpdateContactDetailsRequset extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $prefix = config("srm_config.installer.table_prefix", "srm_");

        return [
            "first_name" => ["required", "string", "max:255"],
            "last_name" => ["required", "string", "max:255"],
            "user_name" => [
                "required", "string", "max:255", Rule::unique("{$prefix}Users", "user_name")
                    ->ignore(auth()->user()->user_ID, "user_ID")
            ],
            "Phone" => ["nullable", "numeric"],
            "Security_question_index" => ["required", "numeric"],
            "Security_answer" => ["required", "string", "max:255"],

        ];
    }

    public function messages()
    {
        return [
            "first_name.required" => "Please enter your first name.",
            "last_name.required" => "Please enter your last name.",
            "user_name.required" => "Username can\'t be empty.",
            "user_name.unique" => "This user name is already registered. Please use a different user name.",
            "user_name.exists" => "This email address is already registered. Please use a different email or log in with your existing account.",
            "Security_answer.required" => "Please provide an answer to the security question. This field cannot be left empty."
        ];
    }
}
