<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateBrandingRequest extends FormRequest
{
    private $width;
    private $height;

    public function __construct()
    {
        parent::__construct();

        $this->width = config('srm_config.dashboard.system_logo.width', 370);
        $this->height = config('srm_config.dashboard.system_logo.height', 70);
    }
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $width = $this->width;
        $height = $this->height;

        return [
            'logo' => ['required', 'mimes:jpeg,png,jpg,gif', 'max:500', "dimensions:width=$width,height=$height"]
        ];
    }

    public function messages()
    {
        $width = $this->width;
        $height = $this->height;

        return [
            'logo.max' => 'Image size can\'t exceed 500KB',
            'logo.mimes' => 'Image type must be PNG, JPG, JPEG, or GIF',
            'logo.dimensions' => "Image width should be $width, and Image height should be $height"
        ];
    }
}
