<?php

namespace App\Http\Requests\Chart;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ApperanceStepRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'chart_type' => ['required'],
            'widget_size' => ['required','in:full,half'],
            'map_selection' => [Rule::requiredIf($this->input('chart_type') === 'geo-chart')],
            'sections_color_palette' => [
                Rule::requiredIf(
                    in_array($this->input('chart_type'), ['pie-chart', '3d-pie-chart', 'donut-chart', '3d-donut-chart'])
                )
            ],
        ];
    }

    public function messages()
    {
        return [
            'chart_type.required' => 'Please select a chart type',
            'widget_size.required' => 'Please select a widget size',
            'map_selection.required' => 'Map Selection  Required. Please specify the type of map you want to display.'
        ];
    }
}
