<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Group;
use App\Models\SMTPMails;
use Illuminate\Http\Request;
use App\Services\UserService;
use App\Services\ModuleService;
use App\Http\Requests\storeUserRequest;
use App\Exceptions\SystemErrorException;
use App\Http\Middleware\OnlyFullVersion;
use App\Http\Requests\updateUserRequest;
use App\Http\Requests\ActivateUserRequest;

class UserController extends Controller
{
    private $moduleService;
    private $userService;

    public function __construct(ModuleService $moduleService, UserService $userService)
    {

        $this->moduleService = $moduleService;
        $this->userService = $userService;

        $this->middleware(OnlyFullVersion::class)->only(
            [
                'store',
                'update',
                'activate',
                'activateAdmin',
                'block',
                'unblock',
                'destroy',
                'destroy'
            ]
        );
    }


    public function index()
    {
        $groups = Group::withCount('users')->get();

        $modules = $this->moduleService->getAllWithResources(['is_active' => true, 'parent_id' => null]);

        $users = $this->userService->getAllUsers();

        return view('dashboard.users.index', compact('groups', 'modules', 'users'));
    }



    public function store(storeUserRequest $request)
    {
        $this->userService->store($request->validated());
        return response()->json([
            'message' => 'User is added successfully'
        ]);
    }


    public function edit(User $user)
    {
        $user->load('group');
        $groups = Group::get();

        return view('dashboard.users.user.edit', compact('user', 'groups'));
    }



    public function update(User $user, updateUserRequest $request)
    {
        $this->userService->update($user, $request->validated());

        return response()->json([
            'message' => trans('users.users_edit_saved')
        ]);
    }

    public function destroy($user, Request $request)
    {
        $user = User::withTrashed()->find($user);

        $this->userService->destroy($user, $request);

        return response()->json([
            'message' => "\"{$user->user_name}\" is deleted successfully."
        ]);
    }

    public function activate(User $user, ActivateUserRequest $request)
    {
        $this->userService->activate($user, $request, false);

        return response()->json([
            'message' => "\"{$user->user_name}\" is activated successfully, Now, they have the capability to log in."
        ]);
    }

    public function activateAdmin(User $user, Request $request)
    {
        $this->userService->activate($user, $request, true);

        return response()->json([
            'message' => "\"{$user->user_name}\" is activated successfully, Now, they have the capability to log in."
        ]);
    }


    public function block(User $user, Request $request)
    {
        $this->userService->block($user, $request);

        return response()->json([
            'message' => "\"{$user->user_name}\" is blocked successfully."
        ]);
    }


    public function unblock(User $user, Request $request)
    {
        $this->userService->unblock($user, $request);

        return response()->json([
            'message' => "\"{$user->user_name}\" is activated successfully, Now, they have the capability to log in."
        ]);
    }
}
