<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\SMTPService;
use App\Http\Middleware\OnlyFullVersion;
use App\Http\Requests\TestSMTPConnectionRequest;

class SMTPServerController extends Controller
{
    public $smtpService;
    public function __construct(SMTPService $smtpService)
    {
        $this->smtpService = $smtpService;

        $this->middleware(OnlyFullVersion::class)->only(
            [
                'update',
                'test',
            ]
        );
    }

    public function update(TestSMTPConnectionRequest $request)
    {
        $this->smtpService->update($request->validated());

        return response()->json([
            'message' => 'SMTP Connection is saved successfully'
        ]);
    }

    public function test(TestSMTPConnectionRequest $request)
    {

        $this->smtpService->checkSMTPConnection($request->validated());

        return response()->json([
            'message' => 'Connection to SMTP is successful'
        ]);
    }
}
