<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use Illuminate\Support\Arr;
use Illuminate\Http\Request;
use App\Services\SMTPService;
use App\Http\Middleware\OnlyFullVersion;
use App\Services\GeneralSettingsService;
use App\Http\Requests\UpdateGeneralSettingsRequest;

class GeneralSettingsController extends Controller
{
    public $generalService;
    public $smtpService;
    public function __construct(GeneralSettingsService $generalService, SMTPService $smtpService)
    {
        $this->generalService = $generalService;
        $this->smtpService = $smtpService;

        $this->middleware(OnlyFullVersion::class)->only(
            [
                'update',
            ]
        );
    }

    public function index()
    {
        $settings = $this->generalService->getSettings();
        $smtp = $this->smtpService->getDeafultSMTPServer();
        return view('dashboard.general.index', compact('settings', 'smtp'));
    }

    public function update(UpdateGeneralSettingsRequest $request)
    {
        $this->generalService->update($request->validated());

        return response()->json([
            "message" => "The ​general settings are updates successfully."
        ]);
    }
}
